/*
 * CSPJFrame.java
 *
 * 
 */
 package DisCSP.CSPApplication;

import javax.swing.*;
import javax.swing.event.*;
import DisCSP.DistributedCSP.*;
import DisCSP.CSPLexerParser.*;
import DisCSP.CSP.*;
import java.awt.event.*;
import java.awt.*;
import java.util.Vector;
import java.io.*;
import java.net.*;
/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */

public class CSPJFrame extends JFrame
{
	
	
	JTextField monIP;
	JTextField monPort;
    JComboBox numAgents;
    JList agentsList;
 	JRadioButtonMenuItem local;
	JRadioButtonMenuItem distributed;
	DefaultListModel listModel;
	JTextArea output;
	boolean modeDistr=false;

	ByteArrayOutputStream byteStr= new ByteArrayOutputStream();
	PrintStream	prtStr=new PrintStream(byteStr);
	
	
	
	Agent[] agents;
	String[] agentsIP; 
	int[] agentsPort;
	Neighbourhood[] nhoods;
	String[] constrProblems;
 
 	/** Costruttore di CSPJFrame
     * 
     * 
     */				   
    public CSPJFrame()
    {
                
        setResizable(false);
        //MenuBar
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        JMenuItem menuFileExit = new JMenuItem("Exit");
        JMenu menuFileMode = new JMenu("Mode");
         
        menuFileExit.addActionListener
        (
            new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    CSPJFrame.this.windowClosed();
                }
            }
        ); 
 
               
        menuFile.add(menuFileMode);       
        menuFile.add(menuFileExit);
        menuBar.add(menuFile);
        
        setTitle("Constraint Satisfaction Problem Solver");
        setJMenuBar(menuBar);
        setSize(new Dimension(800, 700));
        
        this.addWindowListener
        (
            new WindowAdapter()
            {
                public void windowClosing(WindowEvent e)
                {
                    CSPJFrame.this.windowClosed();
                }
            }
        ); 

	    ButtonGroup locDistr= new ButtonGroup();
		local= new JRadioButtonMenuItem("Local");
		local.setSelected(!modeDistr);
		distributed= new JRadioButtonMenuItem("Distributed");

		locDistr.add(local);
		locDistr.add(distributed);
		menuFileMode.add(local);
		menuFileMode.add(distributed);
		//End MenuBar

 
 		Box monIPBox= new Box(BoxLayout.X_AXIS );
        JLabel monIPLabel= new JLabel("Monitor IP: ");
        monIP=new JTextField("",10);
        monIP.setEnabled(false);
		monIPBox.add(monIPLabel);
		monIPBox.add(monIP);
 		Box monPortBox= new Box(BoxLayout.X_AXIS );
		JLabel monPortLabel= new JLabel("Monitor Port: ");
        monPort=new JTextField("",5);
        monPort.setEnabled(false);
        monPortBox.add(monPortLabel);
        monPortBox.add(monPort);         
               
        
 		Box agentsBox= new Box(BoxLayout.X_AXIS );
 		JLabel agentsLabel= new JLabel("Number of Agents: ");
 		DefaultComboBoxModel agentsComboModel=new  DefaultComboBoxModel(); 
        for(int i=1;i<11;i++)
        {
        	agentsComboModel.addElement(new Integer(i));
        }
        numAgents= new JComboBox(agentsComboModel);
        numAgents.setSelectedIndex(0);
        numAgents.setEditable(true);
        numAgents.setEnabled(false); 
		agentsBox.add(agentsLabel);
		agentsBox.add(numAgents);
		
			   	
	   	Box leftSetupBox= new Box(BoxLayout.Y_AXIS );
 		leftSetupBox.add(new JLabel(" "));		
 		leftSetupBox.add(agentsBox);		
 		leftSetupBox.add(new JLabel(" "));		
 		leftSetupBox.add(monIPBox);		
		leftSetupBox.add(monPortBox);
		
		listModel=new  DefaultListModel(); 
       	listModel.addElement("Agent1");
		agentsList= new JList(listModel);
		agentsList.setVisibleRowCount(5);
		agentsList.setFixedCellWidth(125);
		agentsList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION );
		JScrollPane scrollAgentsList = new JScrollPane(agentsList);
		scrollAgentsList.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER );
		scrollAgentsList.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS );
        
        JButton solveButton= new JButton("Solve");
        
        Box setupBox=new Box(BoxLayout.X_AXIS);
		setupBox.add(leftSetupBox);
		setupBox.add(Box.createHorizontalStrut(125));
		setupBox.add(scrollAgentsList);
		setupBox.add(Box.createHorizontalStrut(125));
		setupBox.add(solveButton);
		
        Box outputBox=new Box(BoxLayout.Y_AXIS);
		output= new JTextArea(28,69);
		output.setEditable(false);
	   	JScrollPane scrollOuput = new JScrollPane(output);
		outputBox.add(new JLabel(" "));
		outputBox.add(scrollOuput);
		scrollOuput.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS );
		scrollOuput.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED );
		
		
		agents= new Agent[1];
		agentsIP= new String[1]; 
		String ip="";
		try
		{
			ip=(InetAddress.getLocalHost()).getHostAddress();
		}
		catch(UnknownHostException he)
		{
			
		}
              	
		init(agentsIP, ip );
		agentsPort= new int[1];  
		init(agentsPort,1040);
		nhoods= new Neighbourhood[1];  
		init(nhoods);
		constrProblems= new String[1];       	
		init(constrProblems,"");

		//listener
		numAgents.addItemListener
        (
            new ItemListener()
            {
                public void itemStateChanged(ItemEvent e)
                {
                    int currNumAg= ((Integer)numAgents.getSelectedItem()).intValue();
                    listModel.clear();

					agents= new Agent[currNumAg];
					agentsIP= new String[currNumAg];
					String ip="";
	        		try
	        		{
	        			ip=(InetAddress.getLocalHost()).getHostAddress();
	        		}
					catch(UnknownHostException he)
					{
						
					}
					init(agentsIP,ip);
					agentsPort= new int[currNumAg];  
					init(agentsPort,1040);
					nhoods= new Neighbourhood[currNumAg];  
					init(nhoods);
					constrProblems= new String[currNumAg];       	
					init(constrProblems,"");
					
            
                    for(int i=1;i<=currNumAg;i++)
                    {
       					listModel.addElement("Agent"+i);
                    }
                }
            }
        ); 
        		
		distributed.addChangeListener
		(
			new ChangeListener()
 			{
 				public void stateChanged (ChangeEvent e)
 				{
 					if(distributed.isSelected()&&modeDistr==false)
 					{
 						modeDistr=true;
 						monIP.setEnabled(true);
 						monPort.setEnabled(true);
 						numAgents.setEnabled(true);
 						
 					}
 					if(!distributed.isSelected()&&modeDistr==true)
 					{
 						modeDistr=false;
 						if(((Integer)numAgents.getSelectedItem()).intValue()!=1)
	 						numAgents.setSelectedIndex(0);
 						monIP.setEnabled(false);
 						monPort.setEnabled(false);
 						numAgents.setEnabled(false);
 					}
 					
 				}
 			}

			
		);		
		
	

 		MouseListener mouseListener = new MouseAdapter() 
 		{
    		public void mouseClicked(MouseEvent e)
    		{
        		if (e.getClickCount() == 2)
        		{
            		int index = agentsList.locationToIndex(e.getPoint());
            		String selAgent = (String)listModel.getElementAt(index);
            		AgentSetupJFrame agSetup=new AgentSetupJFrame(selAgent,index,agentsIP,agentsPort,nhoods,constrProblems,modeDistr);
            		agSetup.setVisible(true);

         		}
    		}
		};
		
		
		solveButton.addActionListener
		(
			new ActionListener()
 			{
 				public void actionPerformed (ActionEvent e)
 				{
 					if(modeDistr==false)
 					{
 						solveLocal();
 					}
 					else
 					{
 						solve();
 					}
 					
 				}
 			}			
		);
		
		agentsList.addMouseListener(mouseListener);		
				
		
 		JPanel setupPanel = new JPanel();
 		setupPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),"Setup"));
 		setupPanel.add(setupBox);
  
  		JPanel outputPanel = new JPanel();
 		outputPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),"Result"));
 		outputPanel.add(outputBox);

 		Box tot= new  Box(BoxLayout.Y_AXIS);
 		tot.add(setupPanel);
 		tot.add(outputPanel);
 		
 		this.getContentPane().add(tot);
 	
        this.validate();
 		
 
 
 
    }
    
    protected void windowClosed()
    {
        System.exit(0);
    }
    
    private void solve()
    {
    	try
    	{	    	
	    	output.setText("solving...");
	    	int monPortInt=new Integer(monPort.getText()).intValue();
	  		
	  		for(int i=0;i<agents.length;i++)
	  		{
	  			int num=i+1;
	  			agents[i]=new Agent("Agent"+num,constrProblems[i],agentsIP[i],agentsPort[i],nhoods[i],prtStr,monIP.getText(),monPortInt);
	  		}
	  		
	  		for(int i=0;i<agents.length;i++)
	  		{
	  			agents[i].start();
	  		}    		
 		
	  		for(int i=0;i<agents.length;i++)
	  		{
	  			agents[i].join();
	  		} 
	  		   	
	  		output.setText(byteStr.toString());
	  						
 			
    	}
    	catch(Exception e)
    	{
    		
    	}

    }
    
    private void solveLocal()
    {
    	try
    	{	    	
	  		
			Lexer lex= new Lexer(constrProblems[0]);
			Parser parse=new Parser(lex);
						
			ConstraintProblem pr= parse.parseConstraintProblem();

			PropagationAlgorithm propag= new PropagationAlgorithm();
			propag.arc_consistency(pr);

			output.setText(pr.print());
    	}
     	catch(Exception e)
    	{
    		output.setText(e.getMessage());
    	}

    }

    
    private void init(String[] vett,String val)
    {
    	for(int i=0;i<vett.length;i++)
    	{
    		vett[i]=val;
    	}
    }
    
    private void init(Neighbourhood[] vett)
    {
    	for(int i=0;i<vett.length;i++)
    	{
    		vett[i]=new Neighbourhood();
    	}
    }
    
    private void init(int[] vett,int val)
    {
    	for(int i=0;i<vett.length;i++)
    	{
    		vett[i]=val+10*i;
    	}
    }
     
}